#include<bits/stdc++.h>

using namespace std;

const long long int inf = 2e18 + 5;
const int max_n = 5e5 + 5;

vector<int> path;
int first[max_n];
int height[max_n];
int tree[4 * max_n];


int check(int n1, int n2){
    if (height[n1] < height[n2]) return n1;
    else return n2;
}


void construct(int node, int l, int r){
    if (l == r) tree[node] = path[l];
    else{
        int mid = l + (r - l) / 2;
        construct(node * 2, l, mid);
        construct(node * 2 + 1, mid + 1, r);
        tree[node] = check(tree[node * 2], tree[node * 2 + 1]);
    }
}


int query(int node, int l, int r, int ql, int qr){
    if (qr < l || r < ql) return -1;
    if (ql <= l && r <= qr) return tree[node];
    int mid = l + (r - l) / 2;
    int a1 = query(node * 2, l, mid, ql, qr);
    int a2 = query(node * 2 + 1, mid + 1, r, ql, qr);
    if (a1 == -1) return a2;
    if (a2 == -1) return a1;
    return check(a1, a2);
}


void dfs(int node, int p, int h, vector<vector<int>> &adjs){
    first[node] = path.size();
    path.push_back(node);
    height[node] = h;
    for (int child : adjs[node]) if (child != p){
        dfs(child, node, h + 1, adjs);
        path.push_back(node);
    }
}


void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans){
    vector<vector<int>> adjs(N + 1);
    for (int i = 1; i <= M; i++){
        adjs[U[i]].push_back(V[i]);
        adjs[V[i]].push_back(U[i]);
    }
    dfs(1, -1, 1, adjs);
    int len = path.size();
    construct(1, 0, len - 1);
    int low, high;
    for (int tc = 1; tc <= Q; tc++){
        low = min(first[X[tc]], first[Y[tc]]);
        high = max(first[X[tc]], first[Y[tc]]);
        Ans[tc] = query(1, 0, len - 1, low, high);
    }
}
/*
5 4 1
1 2 1
1 3 1
2 4 1
2 5 1
4 5
*/